-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2023.02.10
-- 
-- add all physical system domains to db table - used in admin pages
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2023.02.10   rre     create this cool feature
--
-- *******************************************************************************
-- select * from et_format_domain_semantic;
 -- delete from et_format_domain_semantic;
 
 insert into et_format_domain_semantic (domain_id_semantic, description, column_title_ui, column_heading_ui, colvalue_default) 
 values 
-- switches
('ZSD_active', 			'active/inactive switch',	'activate',		 			'switch to toggle settings between active/inactive', null),
('ZSD_allow', 			'allow/deny switch',		'allow',		 			'switch to toggle settings between allow/deny to given group', null),
('ZSD_onoff', 			'on/off switch',			'on/off',		 			'switch to toggle settings between on/off', null),
('ZSD_onoffcustomer',	'on/off customer switch',	'on/off Customer Flag',		'switch to toggle customer settings between on/off', null),
('ZSD_use', 			'use/use not switch',		'use/ignore',				'switch to toggle settings between use/ignore', null),
('ZSD_useas', 			'use as indicator',			'use as',					'switch to toggle specifiy explicit usage of object as', null),
('ZSD_mark', 			'mark as indicator',		'mark as',					'switch to toggle mark', null),
-- A
('ZSD_application', 	'Application Code',			'Application',				'Code/Name of Application', null),
('ZSD_autosequence', 	'Autosequence',				'Internal ID of',			'Internal ID of', null),
('ZSD_autosort', 		'Autosort',					'Internal Sort ID',			'Internal ID to sort', null),
-- C
('ZSD_catalogID', 		'Catalog ID',				'Catalog ID',				'Catalog ID', null),
('ZSD_catalogInstance',	'Catalog ID + Instance',	'Catalog.Instance ID',		'Catalog Instance ID (dotted)', null),
('ZSD_categorystring',	'Categorystring',			'Category of',				'(Custom defined) Category of', null),
('ZSD_codeof',			'Code',						'Code of',					'Code of', null),
('ZSD_collection',		'Collection',		    	'Format Collection',		'Collection of format option', null),
('ZSD_commandstring',	'Command String',			'Command to',				'Commandstring to', null),
('ZSD_caption',			'Caption String',			'Caption',					'Captiontext', null),
('ZSD_columnlist',		'Columnlist',	    		'Columnlist',				'List of columns (separated by comma)', null),
('ZSD_columnname', 		'Columnname',				'Columnname',			    'Name of column', null),
('ZSD_collection',		'Collection',	    		'Collection',				'Collection', null),
('ZSD_callable', 		'Unique Callable object',	'Callable Object',			'Callable object', null),
('ZSD_constraint', 		'Unique Constraint name',	'Constraint',				'Constraint', null),
('ZSD_config', 		    'Unique Config ID',			'Name of Configuration',	'Configuration parameter name', null),
('ZSD_configvalue',     'Configuaration Value',		'Value of Configuration',	'Configuration parameter value', null),
('ZSD_connection', 		'Unique Connection Name',	'Connection',				'Connection', null),
('ZSD_connectiontype', 	'Type of Connection',		'Connectiontype',	    	'Connectiontype 0=database, 1=...', null),
-- D
('ZSD_description', 	'Description',				'Description',				'Description', null),
('ZSD_domain', 			'Domain ID ',				'Domain ID',				'Domain ID ', null),
('ZSD_dateof', 			'Date of sth.',				'Date of',					'Date of', null),
('ZSD_datatype', 		'Datatype of sth.',			'Datatype of',				'Datatype of', null),
('ZSD_defaultvalue', 	'Defaultvalue of sth.',		'Defaultvalue of',			'Defaultvalue of', null),
('ZSD_DBconnection', 	'Database Connection',		'DB Connection',			'Database connection', null),
-- E
('ZSD_edittype', 		'Edittype',					'Edittype',					'Edittype of', null),
('ZSD_editsize', 		'Edit Size',				'Edit Size',				'Edit size', null),
('ZSD_email', 			'EMail Address',			'Email Address',			'Full email address', null),
-- F
('ZSD_firstname', 		'Firstname',				'Firstname',				'Firstname', null),
('ZSD_lastname', 		'Lastname',					'Lastname',					'Lastname', null),
('ZSD_filename', 		'Full name of a file',		'File',						'Full name of file', null),
('ZSD_formposition', 	'Form Position Value',		'Formposition',				'Formposition', null),
-- G
('ZSD_gridlocation', 	'Gridlocation',				'Location of',				'Location number (0=left upper, 1, 2, 3=right lower) on grid', null),
('ZSD_GUID', 		    'GUID',						'GUID',						'Global Unique ID', null),
-- H
('ZSD_heading', 		'Mouse over Text',			'Heading of',				'Heading text of', null),
-- I
('ZSD_instance', 		'Instance Name',			'Instance',			    	'Name of catalog object instance', null),
('ZSD_iconfile', 		'Name of Iconfile',			'Iconfile',	    			'Full name of file on server', null),
-- L
('ZSD_language', 		'Language Code',			'Language Code',			'Language Code', null),
('ZSD_label', 		    'Label text',	    		'Label of',			        'Label of', null),
('ZSD_length', 			'Length',					'Length of',				'Length of', null),
('ZSD_level', 			'Level code',				'Level of',					'Level of', null),
('ZSD_loglink', 		'Logical Link',				'Logical Link',				'Logical link', null),
('ZSD_lookup', 			'Unique Lookup ID',			'Lookup',					'Lookup', null),
-- M
('ZSD_messageID', 		'Unique Message ID',		'Message ID',				'Message ID', null),
('ZSD_menu', 			'Unique Menue ID',			'Menu ID',					'Menu ID', null),
('ZSD_managedobject', 	'Mmanaged Object',			'Table or View',			'Name of Table or View (without any extension or schema)', null),
-- N
('ZSD_numeric', 		'Numveric Value',			'Numeric Value',			'Numveric Value', null),
-- O
('ZSD_ordinalpos', 		'Ordinal Position',			'Ordinal Position',			'Ordinal position', null),
-- P
('ZSD_password', 		'Password',					'Password',					'Password', null),
('ZSD_phone', 			'Phone',					'Phonenumber',				'Phonenumber', null),
-- S
('ZSD_session', 		'Session ID',				'Session ID',				'Session ID', null),
('ZSD_sqlclause', 		'SQLclause String',			'SQL',			 	        'SQL Syntax (part)', null),
('ZSD_sortorder', 		'Sortorder',				'Sortorder',				'Sortorder value ', null),
-- T
('ZSD_typeXXX', 		'Type',						'Type of',					'Type of', null),
('ZSD_typeN', 			'Type',						'Type of',					'Type of', null),
('ZSD_type', 			'Type',						'Type of',					'Type of', null),
('ZSD_text', 			'Text',						'Text of',					'Text of', null),
('ZSD_textfilter', 		'Textfilter',				'Filter Criteria',			'Filter criteria', null),
('ZSD_title', 			'Title',					'Title of',					'Title text of', null),
('ZSD_transaction', 	'Unique Transaction Name',	'Transaction Name',	    	'Name of transaction', null),
-- U
('ZSD_user', 			'Unique User ID ',			'User ID',	    			'User ID', null),
('ZSD_UCA', 			'UCA String',				'User Comm. Area',	 		'User Communicatio Area String', null),
('ZSD_usergroup', 		'Unique User Group ID ',	'User Group ID',	    	'User group ID', null)

 as loadval
 on DUPLICATE KEY UPDATE
	description = loadval.description,
	column_title_ui = loadval.column_title_ui,
	column_heading_ui = loadval.column_heading_ui,
	colvalue_default = loadval.colvalue_default
 ;
 